Imports System.Xml
Public Class IPLocation
    Private _City As String
    Private _Country As String
    Private _CountryCode As String
    Private _Lat As Decimal
    Private _Lng As Decimal
    Public Property City() As String
        Get
            Return _City
        End Get
        Set(ByVal value As String)
            _City = value
        End Set
    End Property
    Public Property Country() As String
        Get
            Return _Country
        End Get
        Set(ByVal value As String)
            _Country = value
        End Set
    End Property
    Public Property CountryCode() As String
        Get
            Return _CountryCode
        End Get
        Set(ByVal value As String)
            _CountryCode = value
        End Set
    End Property
    Public Property Lat() As Decimal
        Get
            Return _Lat
        End Get
        Set(ByVal value As Decimal)
            _Lat = value
        End Set
    End Property
    Public Property Lng() As Decimal
        Get
            Return _Lng
        End Get
        Set(ByVal value As Decimal)
            _Lng = value
        End Set
    End Property
    Public Sub New()
        MyBase.New()
    End Sub
    Public Sub New(ByVal ip As String)
        MyBase.New()
        Parse(ip)
    End Sub
    Public Sub Parse(ByVal ip As String)
        Dim xRead As New XmlTextReader("http://api.hostip.info/?ip=" & ip)
        Do While xRead.Read = True
            If xRead.IsStartElement = True Then
                If xRead.Name = "gml:name" Then
                    _City = xRead.ReadString
                End If
                If xRead.Name = "countryName" Then
                    _Country = xRead.ReadString
                End If
                If xRead.Name = "countryAbbrev" Then
                    _CountryCode = xRead.ReadString
                End If
                If xRead.Name = "gml:coordinates" Then
                    Dim latlon As String = xRead.ReadString
                    _Lng = Decimal.Parse(latlon.Split(",")(0))
                    _Lat = Decimal.Parse(latlon.Split(",")(1))
                End If
            End If
        Loop
    End Sub
End Class